

#|________________________________________________________________________
 | 
 | p0301.2-mmmds.lsp
 | Copyright (c) 2000 by Forrest Young
 | ViSta Plugin for Metric Mean Multidimensional Scaling
 |
 | PLUGIN LOADER FUNCTION - MULTIMENSIONAL SCALING of root-mean-squared data
 |#
 
;STEP 1: DEFINE THE SEVEN LOCAL VARIABLES 
;        USED TO PREPARE THE PLUGIN ENVIRONMENT

(let* ((plugin-subdirectory "mamds")
       (plugin-file         "mamdsmain.lsp")
       (menu-item           "Metric Averaged MDS")
       (toolbar-button      "MA-MDS")
       (workmap-icon        "MAM")
       (data-types        '("matrix"))
       (variable-types     '(numeric)))
  (send *vista* :prepare-plugin-environment
        plugin-subdirectory
        plugin-file 
        menu-item 
        toolbar-button
        workmap-icon
        data-types 
        variable-types))


;STEP 2: DEFINE THE LOADER FUNCTION

  (defun metric-averaged-mds 
    (&key 
     (data *current-data*)
     (dialog nil)
     (dimensions 3))
"Performs Metric Averaged Multidimensional Scaling.  With no arguments, performs a 3-dimensional scaling using all active data matrices in the current data. When there is more than one active data matrix, a single matrix is formed for analysis. It is formed by calculating, across matrices, the root-mean-squared value for every element in the data matrix. The result is made symmetric, if necesssary.
Keyword arguments are:
:DIMENSIONS followed by an integer to specify the dimensionality of the analysis (default - and minimum - is 3);
:DATA followed by the name of the data to be analyzed (default: *current-data*);
:DIALOG followed by t (to display parameters dialog box) or nil (default)."
    (format t "; CopyRt: MA-MDS Copyright (c) 1992-2002, by Mary M. McFarlane & Forrest W. Young~%> ")
    (load *ma-mds-plugin-constructor-file*)
    (metric-averaged-mds 
     :data data 
     :dialog dialog 
     :dimensions dimensions))